IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[P_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_COMPARACAO]') AND TYPE IN (N'P', N'PC'))
	DROP PROCEDURE [DBO].[P_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_COMPARACAO]
GO
GO
--exec P_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_COMPARACAO 333891
CREATE PROCEDURE [dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_COMPARACAO] @CD_CTR INT =0
AS
BEGIN
SET NOCOUNT ON;
DECLARE @CD_NF INT
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
CREATE TABLE #RsProdutoDanfe (CD_EMP INT, 
						      CD_FILIAL INT,
							  CD_NF INT,
							  CD_CTR INT,
							  CD_PROD INT,
							  QT_IT MONEY,
							  VLR_BASE_ICMS MONEY,
							  VLR_ICMS_IT MONEY,
							  VLR_BASE_SUBS MONEY,
							  VLR_ICMS_SUBS MONEY,
							  VLR_DESC MONEY,
							  VLR_PROD_FRETE MONEY,
							  VLR_IPI MONEY,
							  VLR_TOTAL_PROD MONEY,
							  VLR_IT MONEY,
							  DELETAR INT,
							  VLR_FECOP_ST MONEY,
							  VLR_ICMS_DESONERADO MONEY,
							  VLR_BASE_FECOP MONEY,
							  PERC_FECOP MONEY,
							  VLR_FECOP MONEY)

CREATE TABLE #RsProdutoNotaFiscal (CD_EMP INT, 
						      CD_FILIAL INT,
							  CD_NF INT,
							  CD_CTR INT,
							  CD_PROD INT,
							  QT_IT MONEY,
							  VLR_BASE_ICMS MONEY,
							  VLR_ICMS_IT MONEY,
							  VLR_BASE_SUBS MONEY,
							  VLR_ICMS_SUBS MONEY,
							  VLR_DESC MONEY,
							  VLR_PROD_FRETE MONEY,
							  VLR_TOTAL_PROD MONEY,
							  VLR_IT MONEY,
							  DELETAR INT,
							  VLR_FECOP_ST MONEY,
							  VLR_ICMS_DESONERADO MONEY,
							  VLR_BASE_FECOP MONEY,
							  PERC_FECOP MONEY,
							  VLR_FECOP MONEY)

		INSERT INTO #RsProdutoDanfe
		SELECT
			EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_EMP,
			EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_FILIAL,
			EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_NF,
			EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_CTR,
			EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_PROD,
			SUM(EMB.QTDE_CONVERTIDO) AS QT_PROD,
			SUM(EST_NF_ENT_DANFE_PROVISORIO_ITENS.VLR_PROD_BASE_ICMS), 
			SUM(EST_NF_ENT_DANFE_PROVISORIO_ITENS.VLR_PROD_ICMS), 
			SUM(EST_NF_ENT_DANFE_PROVISORIO_ITENS.VLR_PROD_BASE_ST), 
			SUM(EST_NF_ENT_DANFE_PROVISORIO_ITENS.VLR_PROD_ICMS_ST),
			SUM(EST_NF_ENT_DANFE_PROVISORIO_ITENS.VLR_PROD_DESC),
			SUM(EST_NF_ENT_DANFE_PROVISORIO_ITENS.VLR_PROD_FRETE),
			SUM(EST_NF_ENT_DANFE_PROVISORIO_ITENS.VLR_PROD_IPI),
			SUM(EST_NF_ENT_DANFE_PROVISORIO_ITENS.VLR_PROD_TOTAL),
			SUM(EST_NF_ENT_DANFE_PROVISORIO_ITENS.VLR_PROD_TOTAL) / SUM(EMB.QTDE_CONVERTIDO) AS VLR_IT,
			0,
			SUM(EST_NF_ENT_DANFE_PROVISORIO_ITENS.VLR_FECOP_ST) AS VLR_FECOP_ST,
			SUM(EST_NF_ENT_DANFE_PROVISORIO_ITENS.VLR_ICMS_DESONERADO) AS VLR_ICMS_DESONERADO,
			SUM(EST_NF_ENT_DANFE_PROVISORIO_ITENS.VLR_BASE_FECOP) AS VLR_BASE_FECOP,
			SUM(EST_NF_ENT_DANFE_PROVISORIO_ITENS.PERC_FECOP)	  AS PERC_FECOP ,
			SUM(EST_NF_ENT_DANFE_PROVISORIO_ITENS.VLR_FECOP)	  AS VLR_FECOP
		FROM
			EST_NF_ENT_DANFE_PROVISORIO_ITENS INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT ON
			EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_CTR 
			INNER JOIN EST_NF_ENT_DANFE_PROVISORIO ON
			EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO.CD_CTR 
			OUTER APPLY UFD_EST_PROD_CONVERTE_EMBALAGEM (EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_EMP,
											 EST_NF_ENT_DANFE_PROVISORIO.CD_FORN,
											 EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_PROD,
											 EST_NF_ENT_DANFE_PROVISORIO_ITENS.QTDE_PROD,
											 EST_NF_ENT_DANFE_PROVISORIO_ITENS.VLR_PROD_TOTAL,
											 EST_NF_ENT_DANFE_PROVISORIO_ITENS.FLAG_USAR_EMB_DANFE,
											 EST_NF_ENT_DANFE_PROVISORIO_ITENS.APRES_QT_CP) EMB
		WHERE
			EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_CTR=@CD_CTR
		GROUP BY
			EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_CTR,
			EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_PROD,
			EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_EMP,
			EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_FILIAL,
			EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_NF,
			EST_NF_ENT_DANFE_PROVISORIO.CD_FORN,
			EST_NF_ENT_DANFE_PROVISORIO_ITENS.FLAG_USAR_EMB_DANFE
		INSERT INTO #RsProdutoNotaFiscal
		SELECT
			EST_NF_ENT_IT.CD_EMP,
			EST_NF_ENT_IT.CD_FILIAL,
			EST_NF_ENT_IT.CD_NF,
			CD_CTR,
			EST_NF_ENT_IT.CD_PROD,
			EST_NF_ENT_IT.QT_IT,
			EST_NF_ENT_IT.VLR_BASE_ICMS, 
			EST_NF_ENT_IT.VLR_ICMS_IT, 
			EST_NF_ENT_IT.VLR_BASE_SUBS, 
			EST_NF_ENT_IT.VLR_ICMS_SUBS,
			EST_NF_ENT_IT.VLR_DESC,
			EST_NF_ENT_IT.VLR_PROD_FRETE,
			EST_NF_ENT_IT.VLR_TOT_IT,
			EST_NF_ENT_IT.VLR_IT,
			0,
			ISNULL(EST_NF_ENT_IT.VLR_FECOP_ST,0),
			ISNULL(EST_NF_ENT_IT.VLR_ICMS_DESONERADO,0),
			ISNULL(EST_NF_ENT_IT.VLR_BASE_FECOP,0),
			ISNULL(EST_NF_ENT_IT.PERC_FECOP,0),
			ISNULL(EST_NF_ENT_IT.VLR_FECOP,0)
		FROM
			EST_NF_ENT_IT INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT ON
			EST_NF_ENT_IT.CD_EMP = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_EMP AND
			EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_FILIAL AND
			EST_NF_ENT_IT.CD_NF = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_NF 
		WHERE
			EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT.CD_CTR=@CD_CTR

		UPDATE
			D
		SET 
			D.DELETAR=1
		FROM
			#RsProdutoDanfe d  inner join #RsProdutoNotaFiscal e on
			d.cd_ctr = e.cd_ctr and
			d.cd_prod = e.cd_prod and
			d.qt_it = e.qt_it and 
			d.VLR_BASE_ICMS = e.VLR_BASE_ICMS and
			d.VLR_ICMS_IT = e.VLR_ICMS_IT and
			d.VLR_BASE_SUBS = e.VLR_BASE_SUBS and
			d.VLR_ICMS_SUBS = e.VLR_ICMS_SUBS and
			d.VLR_DESC  = e.VLR_DESC and
			d.VLR_PROD_FRETE = e.VLR_PROD_FRETE and
			d.VLR_TOTAL_PROD = d.VLR_TOTAL_PROD and
			d.VLR_IT =  e.VLR_IT AND
			d.VLR_FECOP_ST =  e.VLR_FECOP_ST AND
			d.VLR_ICMS_DESONERADO =  e.VLR_ICMS_DESONERADO AND
			d.VLR_BASE_FECOP =  e.VLR_BASE_FECOP AND
			d.PERC_FECOP =  e.PERC_FECOP AND 
			d.VLR_FECOP =  e.VLR_FECOP

		UPDATE
			E
		SET 
			E.DELETAR=1
		FROM
			#RsProdutoDanfe d  inner join #RsProdutoNotaFiscal e on
			d.cd_ctr = e.cd_ctr and
			d.cd_prod = e.cd_prod and
			d.qt_it = e.qt_it and 
			d.VLR_BASE_ICMS = e.VLR_BASE_ICMS and
			d.VLR_ICMS_IT = e.VLR_ICMS_IT and
			d.VLR_BASE_SUBS = e.VLR_BASE_SUBS and
			d.VLR_ICMS_SUBS = e.VLR_ICMS_SUBS and
			d.VLR_DESC  = e.VLR_DESC and
			d.VLR_PROD_FRETE = e.VLR_PROD_FRETE and
			d.VLR_TOTAL_PROD = d.VLR_TOTAL_PROD and
			d.VLR_IT =  e.VLR_IT AND
			d.VLR_FECOP_ST =  e.VLR_FECOP_ST AND
			d.VLR_ICMS_DESONERADO =  e.VLR_ICMS_DESONERADO AND
			d.VLR_BASE_FECOP =  e.VLR_BASE_FECOP AND
			d.PERC_FECOP =  e.PERC_FECOP AND 
			d.VLR_FECOP =  e.VLR_FECOP

		DELETE FROM #RsProdutoDanfe WHERE DELETAR=1
		DELETE FROM #RsProdutoNotaFiscal WHERE DELETAR=1

		UPDATE
			E
		SET
			E.QT_IT = D.QT_IT,
			E.VLR_BASE_ICMS = d.VLR_BASE_ICMS, 
			E.VLR_ICMS_IT = d.VLR_ICMS_IT, 
			E.VLR_BASE_SUBS = d.VLR_BASE_SUBS, 
			E.VLR_ICMS_SUBS = d.VLR_ICMS_SUBS,
			E.VLR_DESC = d.VLR_DESC,
			E.VLR_PROD_FRETE=d.VLR_PROD_FRETE,
			E.VLR_TOT_IT = d.VLR_TOTAL_PROD,
			E.VLR_IT = D.VLR_IT,
			E.VLR_FECOP_ST =  D.VLR_FECOP_ST,
			E.VLR_ICMS_DESONERADO =  D.VLR_ICMS_DESONERADO,
			E.VLR_BASE_FECOP =  D.VLR_BASE_FECOP,
			E.PERC_FECOP =  D.PERC_FECOP,
			E.VLR_FECOP =  D.VLR_FECOP
		FROM
			#RsProdutoDanfe d  inner join EST_NF_ENT_IT e on
			d.cd_EMP = e.CD_EMP and
			d.cd_FILIAL = e.cd_FILIAL and
			d.CD_NF = e.CD_NF and
			d.cd_prod = e.cd_prod 

		SELECT
			TOP 1 @CD_NF=CD_NF,
			@CD_EMP=CD_EMP,
			@CD_FILIAL=CD_FILIAL
		FROM
			#RsProdutoDanfe 

		IF @CD_NF>0
		BEGIN
			EXEC P_EST_NF_ENT_IT_RECALCULO_CUSTO @CD_EMP,@CD_FILIAL,0,0,1,NULL,NULL,0,@CD_NF
		END
		DROP TABLE #RsProdutoDanfe
		DROP TABLE #RsProdutoNotaFiscal
END